# 2:3.64 Apply Guideline [QRPH-64] - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* **2:3.64 Apply Guideline [QRPH-64]**

Publication Build: This will be filled in by the publication tooling

## 2:3.64 Apply Guideline [QRPH-64]

* [2:3.64.1 Scope](#23641-scope)
* [2:3.64.2 Actor Roles](#23642-actor-roles)
* [2:3.64.3 Referenced Standard(s)](#23643-referenced-standards)
* [2:3.64.4 Messages](#23644-messages)
* [2:3.64.5 Security and Audit Considerations](#23645-security-and-audit-considerations)

### 2:3.64.1 Scope

Transaction Apply Guideline [QRPH-64] is used by a Guideline Performer to submit a contextual content bundle to a Guideline Engine and to invoke the $CPGPlanDefinitionApply operation, which will be evaluated based on the submitted content. The transaction response returns a bundle of Request resources representing the proposed activities based on applying the relevant CCGs. The specific transaction content and behavior related to this content will depend upon the [Common Content Model](CCG_v1_actor.md#common-content-model) option to which the Guideline Performer and Guideline Engine actors claim conformance.

### 2:3.64.2 Actor Roles

**Table 2:3.64.2-1: Actor Roles**

| | |
| :--- | :--- |
| Guideline Performer | Submits a well-formed contextual content bundle to the Guideline Engine and invokes the CPGPlanDefinitionApply operation. |
| Guideline Engine | Executes the CPGPlanDefinitionApply operation on the submitted content bundle and returns a bundle of Request resources, one for each of the relevant CCG CARDs that has fired true. |

### 2:3.64.3 Referenced Standard(s)

Transaction Apply Guideline [QRPH-64] is based on the following standards:

* HL7 FHIR standard Release 4 [http://hl7.org/fhir/R4/index.html](http://hl7.org/fhir/R4/index.html)
* CPG STU2 specification: [https://hl7.org/fhir/uv/cpg/STU2/index.html](https://hl7.org/fhir/uv/cpg/STU2/index.html)
* (Optionally) FHIR IPS specification[1](#fn:1): [https://hl7.org/fhir/uv/ips/2024Sep/](https://hl7.org/fhir/uv/ips/2024Sep/)
* (Optionally) IHE mCSD Profile: [https://profiles.ihe.net/ITI/mCSD/index.html](https://profiles.ihe.net/ITI/mCSD/index.html)

### 2:3.64.4 Messages

**Figure 2:3.64.4-1 - Apply Guideline [QRPH-64] Interaction Diagram**


#### 2:3.64.4.1 Trigger Events - Initiator

There **SHOULD** be a **human** in the loop. With human input, a Guideline Performer triggers the initiation of an Apply Guideline transaction loop during a person-centric care encounter to operationalize the application of relevant CCGs and provide recommendations to a **human** actor that will inform the course of the patient’s care.[2](#fn:2)

#### 2:3.64.4.2 Message Semantics - Initiator

The command to apply the relevant CCG(s) for a patient during a care encounter **SHALL** be submitted by the Guideline Performer to the Guideline Engine using the **CPGPlanDefinitionApply** operation[3](#fn:3) as defined by the HL7 CPG-on-FHIR specification.

URL: [base]/PlanDefinition/[id]/$apply

The following parameters are relevant to this transaction:

* The **id** of the relevant PlanDefinition **SHALL** be supplied at the instance level. This PlanDefinition **MAY** be included in the contextual content bundle.
* The **subject** **SHALL** be supplied as a parameter. The subject **SHALL** be a patient.id reference and the identified patient resource **SHALL** be included in the contextual content bundle.
* The **encounter** **SHALL** be supplied as a parameter. The encounter **SHALL** be an encounter.id reference and the identified encounter resource **SHALL** be included in the contextual content bundle.
* Relevant **parameters** **MAY** be supplied, where needed as inputs to CCG libraries.
* The contextual content bundle **SHALL** be included as the **data** parameter in the Apply Guideline transaction. This content bundle **SHALL** adhere to the actor's claimed contextual content option.

#### 2:3.64.4.3 Expected Actions - Initiator

Prior to submitting the transaction, the transaction initiator:

* **SHALL** prepare an up-to-date contextual content bundle adherent to the actor's claimed contextual content option.
* **SHALL** create an audit record of the transaction submission (see [Security section](CCG_v2_x4.md#23645-security-and-audit-considerations)).

Based on receipt of the transaction response, the transaction initiator:

* **SHALL** create an audit record of the transaction response (see [Security section](CCG_v2_x4.md#23645-security-and-audit-considerations)).
* **SHALL** process each of the Action resources in the RequestGroup and generate Resulting Data based on the [CARD type](CCG_v3_launch.md#normative-action-and-resulting-data-formats), for actors claiming adherence to Volume 3, or based on the relevant specifications defined in Volume 4 (for actors claiming such conformance).

#### 2:3.64.4.4 Trigger Events - Responder

The Guideline Engine responds to inbound Apply Guideline transactions as they are received.

#### 2:3.64.4.5 Message Semantics - Responder

The transaction result returned by the Guideline Engine **SHALL** conform to the content defined for the CPGPlanDefinitionApply[4](#fn:12) operation.

Each Request resource returned in the transaction response bundle **SHALL** reference the relevant “CARD’s” PlanDefinition resource in the [resource].instantiatesCanonical or the [resource].extension:instantiatesCanonical element, as applicable. For Request resources based on the FHIR **Task** resource, the relevant "CARD's" PlanDefinition resource **SHALL** be referenced in the [resource].instantiatesUri element.

#### 2:3.64.4.6 Expected Actions - Responder

Upon receiving a submitted transaction, the transaction responder:

* **MAY** confirm the transaction initiator’s authentication to the Guideline Engine and their authority to execute the submitted transaction;
* **SHALL**, when processing CARDs with multiple condition statements, logically AND the condition statements together;
* **SHALL** return a response in accordance with the Message Semantics – Responder, defined above;
* **SHALL** create an audit record of the transaction submission (see Security section).

Based on the returned transaction response, the transaction responder:

* **SHALL** create an audit record of the transaction response (see Security section);
* Executes other processes in accordance with its application logic.

### 2:3.64.5 Security and Audit Considerations

This transaction **does** convey personal health information (**PHI**); it is present in the data content conveyed by the Guideline Performer to the Guideline Engine during the Apply Guideline transaction and in the transaction response.

FHIR-related security considerations related to the secure processing of PHI **SHALL** be adopted as described in IHE Appendix Z[5](#fn:13).

The Guideline Performer **SHALL** be grouped with Audit Creator actor and **SHALL** adhere to the Basic Audit Log Patterns (BALP)[6](#fn:14) specifications.

The Guideline Engine **SHALL** be grouped with Audit Creator actor and **SHALL** adhere to the Basic Audit Log Patterns (BALP) specifications.

Upon every **submission** of an Apply Guideline transaction, the Guideline Performer and the Guideline Engine **SHALL** both act as an Audit Creator to persist a Basic AuditEvent for Privacy Disclosure at Source.[7](#fn:15) Specifically, the following AuditEvent content **SHALL** be included:

* AuditEvent.outcome = 0 (regardless of the eventual transaction response)
* AuditEvent.outcomeDesc = submission statement content from the Apply Guideline transaction, concatenated with “|” delimiters:
* AuditEvent.purposeOfEvent = “TREAT”
* AuditEvent.agent.source.who = software name and version # of Guideline Performer; where applicable, **SHALL** match the software name and version # named in the conformance statement resulting from participation at Connectathon test events.
* AuditEvent.agent.recipient.who = software name and version # of Guideline Engine; where applicable, **SHALL** match the software name and version # named in the conformance statement resulting from participation at Connectathon test events.
* AuditEvent.agent.custodian.who = practitioner.identifier (for provider-care context) or patient.identifier (for self-care context)
* AuditEvent.agent.authorizer.who = patient.identifier

Upon every **response** to an Apply Guideline transaction submission, the Guideline Engine and the Guideline Performer **SHALL** both act as an Audit Creator to persist a Basic AuditEvent for Privacy Disclosure at Source. Specifically, the following AuditEvent content **SHALL** be included:

* AuditEvent.outcome = 0 or operation outcome code from Guideline Engine server
* AuditEvent.outcomeDesc = the list of Request resource “CARD” ids returned in the Apply Guideline transaction, concatenated with “|” delimiters. NOTE: these values are returned in the resource’s instantiatesCanonical elements.
* AuditEvent.purposeOfEvent = “TREAT”
* AuditEvent.agent.source.who = software name and version # of Guideline Performer; where applicable, **SHALL** match the software name and version # named in the conformance statement resulting from participation at Connectathon test events.
* AuditEvent.agent.recipient.who = software name and version # of Guideline Engine; where applicable, **SHALL** match the software name and version # named in the conformance statement resulting from participation at Connectathon test events.
* AuditEvent.agent.custodian.who = practitioner.identifier (for provider-care context) or patient.identifier (for self-care context)
* AuditEvent.agent.authorizer.who = patient.identifier

For all PHI persisted by the Guideline Performer during its post-processing of the Apply Guideline response, it **SHALL** act as an Audit Creator to persist a Basic AuditEvent for a **successful** **Create with known Patient Subject**.[8](#fn:16)

A Guideline Engine **MAY**, per its CCG transaction processing design, enduringly persist content submitted in the Apply Guideline transaction. Where this is so, the Guideline Engine **SHALL** act as an Audit Creator to persist a Basic AuditEvent for a **successful** **Create with known Patient Subject**.

**Footnotes**

1. The use of the IPS specification in this context is based on the IHE IPS Profile and the**COMPLETE option**defined therein. [↩](#fnref:1)
1. Note: it is anticipated that there is a**human**in the loop to action the care recommendations. In some jurisdictions, a digital health solution playing the role of a Guideline Performer and/or a Guideline Engine may meet the definition of Software as a Medical Device (SaMD). [↩](#fnref:2)
1. [https://hl7.org/fhir/uv/cpg/STU2/OperationDefinition-cpg-plandefinition-apply.html](https://hl7.org/fhir/uv/cpg/STU2/OperationDefinition-cpg-plandefinition-apply.html) [↩](#fnref:3)
1. [https://build.fhir.org/ig/HL7/cqf-recommendations/OperationDefinition-cpg-plandefinition-apply.html](https://build.fhir.org/ig/HL7/cqf-recommendations/OperationDefinition-cpg-plandefinition-apply.html) [↩](#fnref:12)
1. [https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.8-mobile-security-considerations](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.8-mobile-security-considerations) [↩](#fnref:13)
1. [https://profiles.ihe.net/ITI/BALP/index.html](https://profiles.ihe.net/ITI/BALP/index.html) [↩](#fnref:14)
1. [https://profiles.ihe.net/ITI/BALP/StructureDefinition-IHE.BasicAudit.PrivacyDisclosure.Source.html](https://profiles.ihe.net/ITI/BALP/StructureDefinition-IHE.BasicAudit.PrivacyDisclosure.Source.html) [↩](#fnref:15)
1. [https://profiles.ihe.net/ITI/BALP/StructureDefinition-IHE.BasicAudit.PatientCreate.html](https://profiles.ihe.net/ITI/BALP/StructureDefinition-IHE.BasicAudit.PatientCreate.html) [↩](#fnref:16)

| | | |
| :--- | :--- | :--- |
|  [<prev](CCG_v2_x3.md) | [top](#top) |  [next>](CCG_v3_launch.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

