# Guideline Engine - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Guideline Engine**

Publication Build: This will be filled in by the publication tooling

*  [Narrative Content](#) 
*  [XML](CapabilityStatement-IHE.CCG.GuidelineEngine.xml.md) 
*  [JSON](CapabilityStatement-IHE.CCG.GuidelineEngine.json.md) 
*  [TTL](CapabilityStatement-IHE.CCG.GuidelineEngine.ttl.md) 

## CapabilityStatement: Guideline Engine 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/CapabilityStatement/IHE.CCG.GuidelineEngine | *Version*:1.0.0 |
| Active as of 2025-02-12 | *Computable Name*:IHE_CCG_GuidelineEngine |

 
IHE QRPH Computable Care Guidelines (CCG) - Guideline Engine. 

 [Raw OpenAPI-Swagger Definition file](IHE.CCG.GuidelineEngine.openapi.json) | [Download](IHE.CCG.GuidelineEngine.openapi.json) 

## Guideline Engine

* Implementation Guide Version: 1.0.0 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+xml`, `application/fhir+json`
* Published on: 2025-02-12 
* Published by: IHE QRPH Technical Committee 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

**Security**

> 

Recommend [ATNA](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html), encouraged [IHE-IUA](https://profiles.ihe.net/ITI/IUA/index.html) or SMART-on-FHIR


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Bundle](#Bundle1-1) | [https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-bundle](StructureDefinition-ccg-di-bundle.md) | y | y | y | y | _id |  |  | `$$apply` |

-------

#### Resource Conformance: supported Bundle

Base System Profile

[CCG Data In Bundle](StructureDefinition-ccg-di-bundle.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `create`, `update`, `read`, `search-type`.

Search Parameters


 

Extended Operations


| | | |
| :--- | :--- | :--- |
|  [<prev](artifacts.md) | [top](#top) |  [next>](CapabilityStatement-IHE.CCG.GuidelineEngine-testing.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

