# Activity Definition for the Collect Information CARD - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Activity Definition for the Collect Information CARD**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-card-collect-ad-definitions.md) 
*  [Mappings](StructureDefinition-ccg-card-collect-ad-mappings.md) 
*  [Examples](StructureDefinition-ccg-card-collect-ad-examples.md) 
*  [XML](StructureDefinition-ccg-card-collect-ad.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-card-collect-ad.profile.json.md) 
*  [TTL](StructureDefinition-ccg-card-collect-ad.profile.ttl.md) 

## Resource Profile: Activity Definition for the Collect Information CARD 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-collect-ad | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_Collect_Info_Activity |

 
Simple profile to inherit the base and set topic to the appropriate CARD 

**Usages:**

* Refer to this Profile: [CCG CARD type - Collect Information](StructureDefinition-ccg-card-collect.md)
* Examples for this Profile: [ActivityExampleCollectInformationAD](ActivityDefinition-activity-example-collectinformation-ad.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-card-collect-ad)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGCollectInformationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-collectinformationactivity.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGCollectInformationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-collectinformationactivity.html) 

**Summary**

Mandatory: 6 elements
 Fixed: 1 element

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CPGCollectInformationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-collectinformationactivity.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGCollectInformationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-collectinformationactivity.html) 

**Summary**

Mandatory: 6 elements
 Fixed: 1 element

 

Other representations of profile: [CSV](StructureDefinition-ccg-card-collect-ad.csv), [Excel](StructureDefinition-ccg-card-collect-ad.xlsx), [Schematron](StructureDefinition-ccg-card-collect-ad.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-adminrx-ad.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-card-collect-ad-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

