# Activity Definition for the Dispense Medication CARD - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Activity Definition for the Dispense Medication CARD**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-card-disprx-ad-definitions.md) 
*  [Mappings](StructureDefinition-ccg-card-disprx-ad-mappings.md) 
*  [Examples](StructureDefinition-ccg-card-disprx-ad-examples.md) 
*  [XML](StructureDefinition-ccg-card-disprx-ad.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-card-disprx-ad.profile.json.md) 
*  [TTL](StructureDefinition-ccg-card-disprx-ad.profile.ttl.md) 

## Resource Profile: Activity Definition for the Dispense Medication CARD 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-disprx-ad | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_Dispense_Medication_Activity |

 
Simple profile to inherit the base and set topic to the appropriate CARD 

**Usages:**

* Refer to this Profile: [CCG CARD type - Dispense Medication](StructureDefinition-ccg-card-disprx.md)
* Examples for this Profile: [ActivityExampleDispenseMedicationAD](ActivityDefinition-activity-example-dispensemedication-ad.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-card-disprx-ad)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGDispenseMedicationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-dispensemedicationactivity.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGDispenseMedicationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-dispensemedicationactivity.html) 

**Summary**

Mandatory: 6 elements
 Fixed: 1 element

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CPGDispenseMedicationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-dispensemedicationactivity.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGDispenseMedicationActivity](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-dispensemedicationactivity.html) 

**Summary**

Mandatory: 6 elements
 Fixed: 1 element

 

Other representations of profile: [CSV](StructureDefinition-ccg-card-disprx-ad.csv), [Excel](StructureDefinition-ccg-card-disprx-ad.xlsx), [Schematron](StructureDefinition-ccg-card-disprx-ad.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-collect-ad.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-card-disprx-ad-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

