# CCG CARD type - Dispense Medication - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG CARD type - Dispense Medication**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-card-disprx-definitions.md) 
*  [Mappings](StructureDefinition-ccg-card-disprx-mappings.md) 
*  [Examples](StructureDefinition-ccg-card-disprx-examples.md) 
*  [XML](StructureDefinition-ccg-card-disprx.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-card-disprx.profile.json.md) 
*  [TTL](StructureDefinition-ccg-card-disprx.profile.ttl.md) 

## Resource Profile: CCG CARD type - Dispense Medication 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-disprx | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_Dispense_Medication |

 
The role of this type of CCG CARD is to create a medication dispensation for the patient. 

**Usages:**

* Examples for this Profile: [ExampleCARDdisprx](PlanDefinition-card-example-disprx.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-card-disprx)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Activity Definition for the Dispense Medication CARD(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-disprx-ad)](StructureDefinition-ccg-card-disprx-ad.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Activity Definition for the Dispense Medication CARD(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-disprx-ad)](StructureDefinition-ccg-card-disprx-ad.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 

Other representations of profile: [CSV](StructureDefinition-ccg-card-disprx.csv), [Excel](StructureDefinition-ccg-card-disprx.xlsx), [Schematron](StructureDefinition-ccg-card-disprx.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-collect.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-card-disprx-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

