# CCG CARD type - Request Immunization - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG CARD type - Request Immunization**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-card-reqvx-definitions.md) 
*  [Mappings](StructureDefinition-ccg-card-reqvx-mappings.md) 
*  [Examples](StructureDefinition-ccg-card-reqvx-examples.md) 
*  [XML](StructureDefinition-ccg-card-reqvx.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-card-reqvx.profile.json.md) 
*  [TTL](StructureDefinition-ccg-card-reqvx.profile.ttl.md) 

## Resource Profile: CCG CARD type - Request Immunization 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-reqvx | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_Request_Immunization |

 
The role of this type of CCG CARD is to recommend and record an immunization event for the patient. Importantly, this CARD does not create an order for a future planned immunization. 

**Usages:**

* Examples for this Profile: [ExampleCARDreqvx](PlanDefinition-card-example-reqvx.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-card-reqvx)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Activity Definition for the Request Immunization CARD(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-reqvx-ad)](StructureDefinition-ccg-card-reqvx-ad.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Activity Definition for the Request Immunization CARD(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-reqvx-ad)](StructureDefinition-ccg-card-reqvx-ad.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 

Other representations of profile: [CSV](StructureDefinition-ccg-card-reqvx.csv), [Excel](StructureDefinition-ccg-card-reqvx.xlsx), [Schematron](StructureDefinition-ccg-card-reqvx.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-reqrefserv.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-card-reqvx-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

