# CCG Data In Bundle - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG Data In Bundle**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-di-bundle-definitions.md) 
*  [Mappings](StructureDefinition-ccg-di-bundle-mappings.md) 
*  [XML](StructureDefinition-ccg-di-bundle.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-di-bundle.profile.json.md) 
*  [TTL](StructureDefinition-ccg-di-bundle.profile.ttl.md) 

## Resource Profile: CCG Data In Bundle 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-bundle | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_DataIn_Bundle |

 
CCG Data Input Bundle. A container for a collection of resources that is passed as part of the Apply Guideline transaction submission. This bundle represents the content that will be used by the Guideline Engine to evaluate all relevant CCG CARD&s condition statements during the $apply operation. 

**Usages:**

* CapabilityStatements using this Profile: [Guideline Engine](CapabilityStatement-IHE.CCG.GuidelineEngine.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-di-bundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 13 elements
 Must-Support: 2 elements
 Fixed: 1 element
 Prohibited: 3 elements

**Structures**

This structure refers to these other structures:

* [CCG Data-In Bundle Encounter(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-encounter)](StructureDefinition-ccg-di-encounter.md)
* [CCG Data-In Bundle Practitioner(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-practitioner)](StructureDefinition-ccg-di-practitioner.md)
* [CCG Data-In Bundle PractitionerRole(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-practitionerrole)](StructureDefinition-ccg-di-practitionerrole.md)
* [CCG Data-In Bundle Location(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-location)](StructureDefinition-ccg-di-location.md)
* [CCG Data-In Bundle Organization(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-organization)](StructureDefinition-ccg-di-organization.md)
* [CCG IPS Bundle(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-ips-bundle)](StructureDefinition-ccg-di-ips-bundle.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 13 elements
 Must-Support: 2 elements
 Fixed: 1 element
 Prohibited: 3 elements

**Structures**

This structure refers to these other structures:

* [CCG Data-In Bundle Encounter(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-encounter)](StructureDefinition-ccg-di-encounter.md)
* [CCG Data-In Bundle Practitioner(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-practitioner)](StructureDefinition-ccg-di-practitioner.md)
* [CCG Data-In Bundle PractitionerRole(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-practitionerrole)](StructureDefinition-ccg-di-practitionerrole.md)
* [CCG Data-In Bundle Location(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-location)](StructureDefinition-ccg-di-location.md)
* [CCG Data-In Bundle Organization(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-organization)](StructureDefinition-ccg-di-organization.md)
* [CCG IPS Bundle(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-ips-bundle)](StructureDefinition-ccg-di-ips-bundle.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

 

Other representations of profile: [CSV](StructureDefinition-ccg-di-bundle.csv), [Excel](StructureDefinition-ccg-di-bundle.xlsx), [Schematron](StructureDefinition-ccg-di-bundle.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-stopsrv.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-di-bundle-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

