# CCG IPS Bundle - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG IPS Bundle**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-di-ips-bundle-definitions.md) 
*  [Mappings](StructureDefinition-ccg-di-ips-bundle-mappings.md) 
*  [XML](StructureDefinition-ccg-di-ips-bundle.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-di-ips-bundle.profile.json.md) 
*  [TTL](StructureDefinition-ccg-di-ips-bundle.profile.ttl.md) 

## Resource Profile: CCG IPS Bundle 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-ips-bundle | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_IPS_Bundle |

 
This bundle follows the IPS Bundle with the exception of using the CCG Composition 

**Usages:**

* Use this Profile: [CCG Data In Bundle](StructureDefinition-ccg-di-bundle.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-di-ips-bundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 8 elements(27 nested mandatory elements)
 Must-Support: 4 elements
 Fixed: 1 element
 Prohibited: 3 elements

**Structures**

This structure refers to these other structures:

* [CCG Data-In Bundle IPS Composition Resource(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-ips-composition)](StructureDefinition-ccg-di-ips-composition.md)
* [Patient (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Patient-uv-ips.html)
* [Allergy Intolerance (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-AllergyIntolerance-uv-ips.html)
* [Condition (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Condition-uv-ips.html)
* [Device Use Statement (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/DeviceUseStatement-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-DeviceUseStatement-uv-ips.html)
* [DiagnosticReport (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/DiagnosticReport-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-DiagnosticReport-uv-ips.html)
* [Imaging Study (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/ImagingStudy-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-ImagingStudy-uv-ips.html)
* [Immunization (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Immunization-uv-ips.html)
* [Medication (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Medication-uv-ips.html)
* [Medication Request (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationRequest-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-MedicationRequest-uv-ips.html)
* [Medication Statement (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-MedicationStatement-uv-ips.html)
* [Practitioner (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Practitioner-uv-ips.html)
* [PractitionerRole (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/PractitionerRole-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-PractitionerRole-uv-ips.html)
* [Procedure (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Procedure-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Procedure-uv-ips.html)
* [Organization (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Organization-uv-ips.html)
* [Observation - Pregnancy: EDD(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-edd-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-edd-uv-ips.html)
* [Observation - Pregnancy: outcome(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-outcome-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-outcome-uv-ips.html)
* [Observation - Pregnancy: status(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-status-uv-ips.html)
* [Observation - SH: alcohol use(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-alcoholuse-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-alcoholuse-uv-ips.html)
* [Observation - SH: tobacco use(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-tobaccouse-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-tobaccouse-uv-ips.html)
* [Observation Results: pathology (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-pathology-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-results-pathology-uv-ips.html)
* [Observation Results: radiology (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-radiology-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-results-radiology-uv-ips.html)
* [Vital Signs Profile(http://hl7.org/fhir/StructureDefinition/vitalsigns)](http://hl7.org/fhir/R4/vitalsigns.html)
* [Specimen (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Specimen-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Specimen-uv-ips.html)
* [CCG Data-In Bundle IPS CarePlan Specific Resource(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-data-in-ips-careplan)](StructureDefinition-ccg-data-in-ips-careplan.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 8 elements(27 nested mandatory elements)
 Must-Support: 4 elements
 Fixed: 1 element
 Prohibited: 3 elements

**Structures**

This structure refers to these other structures:

* [CCG Data-In Bundle IPS Composition Resource(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-ips-composition)](StructureDefinition-ccg-di-ips-composition.md)
* [Patient (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Patient-uv-ips.html)
* [Allergy Intolerance (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-AllergyIntolerance-uv-ips.html)
* [Condition (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Condition-uv-ips.html)
* [Device Use Statement (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/DeviceUseStatement-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-DeviceUseStatement-uv-ips.html)
* [DiagnosticReport (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/DiagnosticReport-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-DiagnosticReport-uv-ips.html)
* [Imaging Study (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/ImagingStudy-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-ImagingStudy-uv-ips.html)
* [Immunization (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Immunization-uv-ips.html)
* [Medication (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Medication-uv-ips.html)
* [Medication Request (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationRequest-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-MedicationRequest-uv-ips.html)
* [Medication Statement (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-MedicationStatement-uv-ips.html)
* [Practitioner (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Practitioner-uv-ips.html)
* [PractitionerRole (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/PractitionerRole-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-PractitionerRole-uv-ips.html)
* [Procedure (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Procedure-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Procedure-uv-ips.html)
* [Organization (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Organization-uv-ips.html)
* [Observation - Pregnancy: EDD(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-edd-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-edd-uv-ips.html)
* [Observation - Pregnancy: outcome(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-outcome-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-outcome-uv-ips.html)
* [Observation - Pregnancy: status(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-status-uv-ips.html)
* [Observation - SH: alcohol use(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-alcoholuse-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-alcoholuse-uv-ips.html)
* [Observation - SH: tobacco use(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-tobaccouse-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-tobaccouse-uv-ips.html)
* [Observation Results: pathology (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-pathology-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-results-pathology-uv-ips.html)
* [Observation Results: radiology (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-radiology-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-results-radiology-uv-ips.html)
* [Vital Signs Profile(http://hl7.org/fhir/StructureDefinition/vitalsigns)](http://hl7.org/fhir/R4/vitalsigns.html)
* [Specimen (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Specimen-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Specimen-uv-ips.html)
* [CCG Data-In Bundle IPS CarePlan Specific Resource(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-data-in-ips-careplan)](StructureDefinition-ccg-data-in-ips-careplan.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

 

Other representations of profile: [CSV](StructureDefinition-ccg-di-ips-bundle.csv), [Excel](StructureDefinition-ccg-di-ips-bundle.xlsx), [Schematron](StructureDefinition-ccg-di-ips-bundle.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-deployment.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-di-ips-bundle-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

