# CCG Patient Plans (patient-specific) PlanDefinition - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG Patient Plans (patient-specific) PlanDefinition**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-patient-plans-definitions.md) 
*  [Mappings](StructureDefinition-ccg-patient-plans-mappings.md) 
*  [Examples](StructureDefinition-ccg-patient-plans-examples.md) 
*  [XML](StructureDefinition-ccg-patient-plans.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-patient-plans.profile.json.md) 
*  [TTL](StructureDefinition-ccg-patient-plans.profile.ttl.md) 

## Resource Profile: CCG Patient Plans (patient-specific) PlanDefinition 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-patient-plans | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_Patient_Plans |

 
A patient-specific PlanDefinition holds the list of one or more applicable CCG Folders. 

**Usages:**

* Refer to this Profile: [CCG Data-In Bundle IPS CarePlan Specific Resource](StructureDefinition-ccg-data-in-ips-careplan.md)
* Examples for this Profile: [PlanDefinition/CCG-patient-plans-example](PlanDefinition-CCG-patient-plans-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-patient-plans)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [PlanDefinition](http://hl7.org/fhir/R4/plandefinition.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [PlanDefinition](http://hl7.org/fhir/R4/plandefinition.html) 

**Summary**

Mandatory: 3 elements
 Fixed: 1 element

**Structures**

This structure refers to these other structures:

* [CCG CARD Folder PlanDefinition(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-folder)](StructureDefinition-ccg-card-folder.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [PlanDefinition](http://hl7.org/fhir/R4/plandefinition.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [PlanDefinition](http://hl7.org/fhir/R4/plandefinition.html) 

**Summary**

Mandatory: 3 elements
 Fixed: 1 element

**Structures**

This structure refers to these other structures:

* [CCG CARD Folder PlanDefinition(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-folder)](StructureDefinition-ccg-card-folder.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 

Other representations of profile: [CSV](StructureDefinition-ccg-patient-plans.csv), [Excel](StructureDefinition-ccg-patient-plans.xlsx), [Schematron](StructureDefinition-ccg-patient-plans.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-library.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-patient-plans-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

