# ValueSet of all Current CCG Card Types - Computable Care Guidelines v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ValueSet of all Current CCG Card Types**

Publication Build: This will be filled in by the publication tooling

*  [Narrative Content](#) 
*  [XML](ValueSet-ccg-card-type.xml.md) 
*  [JSON](ValueSet-ccg-card-type.json.md) 
*  [TTL](ValueSet-ccg-card-type.ttl.md) 

## ValueSet: ValueSet of all Current CCG Card Types 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/ValueSet/ccg-card-type | *Version*:1.0.0 |
| Active as of 2025-10-02 | *Computable Name*:CCG_Card_Type |

 
This list includes all currently defined CCG CARD Types 

 **References** 

* [Activity Definition for the Administer Medication CARD](StructureDefinition-ccg-card-adminrx-ad.md)
* [Activity Definition for the Collect Information CARD](StructureDefinition-ccg-card-collect-ad.md)
* [Activity Definition for the Dispense Medication CARD](StructureDefinition-ccg-card-disprx-ad.md)
* [Activity Definition for the Order Medication CARD](StructureDefinition-ccg-card-orderrx-ad.md)
* [Activity Definition for the Propose a Diagnosis CARD](StructureDefinition-ccg-card-proposedx-ad.md)
* [Activity Definition for the Provide Information CARD](StructureDefinition-ccg-card-provide-ad.md)
* [Activity Definition for the Request a Service (Lab Order) CARD](StructureDefinition-ccg-card-reqlabs-ad.md)
* [Activity Definition for the Request a Service (Procedure Order) CARD](StructureDefinition-ccg-card-reqprocserv-ad.md)
* [Activity Definition for the Request a Service (Radiology Order) CARD](StructureDefinition-ccg-card-reqradserv-ad.md)
* [Activity Definition for the Request a Service (Referral) CARD](StructureDefinition-ccg-card-reqrefserv-ad.md)
* [Activity Definition for the Request Immunization CARD](StructureDefinition-ccg-card-reqvx-ad.md)
* [Activity Definition for the Stop Activity (Medication Order) CARD](StructureDefinition-ccg-card-stoprx-ad.md)
* [Activity Definition for the Stop Activity (Service Order) CARD](StructureDefinition-ccg-card-stopsrv-ad.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://profiles.ihe.net/QRPH/CCG/CodeSystem/ccg-card-type-cs`](CodeSystem-ccg-card-type-cs.md)

 

### Expansion

Expansion performed internally based on [codesystem Code System for All CCG Card Types v1.0.0 (CodeSystem)](CodeSystem-ccg-card-type-cs.md)

This value set contains 13 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-ccg-signature-target.ttl.md) | [top](#top) |  [next>](ValueSet-ccg-card-type-testing.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

